
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/thief_ds.zip" ),
		
	
}
local prefabs = {
	
	
}
local start_inv = {
	-- Custom starting items
	"estus_full",
	
	
}

local disallowed_equipment = {
    --Don't Starve prefabs
	"armor_sanity",
	"armorgrass",
	"armorwood",
	"armormarble",
	"footballhat",
	"armordragonfly",
	"armorsnurtleshell",
	"slurtlehat",
	
	--T.A.P prefabs
	"bonearmor",
	"bonehelm",
	"spiderhelm",
	"queenhelm",
	"metalarmor",
	"forcefieldn",
	
	--Madman fighting Pack prefabs
	"goldarmor",
	"goldhelm",
	
	--emeralds
	"emerald_armor",
	
	--rockarmor
	"hat_wood",
	"hat_rock",
	"armor_rock",
	"hat_marble",
	"hat_hound",
	"hornucopia",
	"armor_beefalo",
}

local function NoArmor ( inst, data )
    local item = data.item
    if table.contains( disallowed_equipment, item.prefab ) then
		inst.components.talker:Say("It's not my style")
        inst:DoTaskInTime(0.5, function()
			GetPlayer().components.inventory:DropItem(item)
		end) 
    end
end

local fn = function(inst)

	table.insert(inst.components.eater.foodprefs, "FLASK")
	table.insert(inst.components.eater.ablefoods, "FLASK")
	
	-- choose which sounds this character will play
	inst.soundsname = "wickerbottom"

	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "thief_ds.tex" )
	
	-- Stats	
	inst.components.health:SetMaxHealth(100)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(170)
	
	-- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = 0.9
	
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 0.8 * TUNING.WILSON_HUNGER_RATE
	
	-- Movement speed (optional)
	inst.components.locomotor.walkspeed = 6
	inst.components.locomotor.runspeed = 8
	inst.components.sanity.neg_aura_mult = 0.8
	inst.components.combat.min_attack_period = 0.2
	inst.components.sanity.night_drain_mult = 0.8
	
	inst:ListenForEvent( "equip", NoArmor )

	  
end

return MakePlayerCharacter("thief_ds", prefabs, assets, fn, start_inv)
